/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.recap;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Recap;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatosRecap
extends ObjetoModeloSucesorValidable<Recap>
implements InformacionEditable<DatosRecap>,
Importable {
    private static final long serialVersionUID = 4990867763145211508L;
    public static final String C_TIPO_COMPROBANTE = "tipoComprobante";
    public static final String C_NUMERO_RECAP = "numeroRecap";
    public static final String C_FECHA_PAGO = "fechaPago";
    public static final String C_TIPO_TARJETA_CREDITO = "tipoTarjetaCredito";
    public static final String C_FECHA_EMISION = "fechaEmision";
    private static final String MSJ_NUM_RECAP = "El valor n\u00famero de RECAP solo consta de n\u00fameros y letras, se autocompletar\u00e1 el valor a quince caracteres";
    private String tipoTarjetaCredito;
    private String descripcionTarjetaCredito;
    private String tipoComprobante;
    private String descripcionTipoComprobante;
    private String numeroRecap;
    private Date fechaPago;
    private Date fechaEmision = new Date();

    public DatosRecap() {
        this.fechaPago = new Date();
    }

    public void inicializar() {
        this.fechaEmision = ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado().getTime();
        this.fechaPago = ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado().getTime();
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (StringUtil.isNullOrEmpty((String)this.getTipoComprobante())) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de Comprobante");
        }
        if (StringUtil.isNullOrEmpty((String)this.getNumeroRecap())) {
            return resultado.fallarValidacion("Debe ingresar el valor de n\u00famero de RECAP");
        }
        Pattern patron = Pattern.compile("^[a-zA-Z0-9]{15}$");
        Matcher matcher = patron.matcher(this.getNumeroRecap());
        if (!matcher.matches()) {
            return resultado.fallarValidacion(MSJ_NUM_RECAP);
        }
        if (!this.validarFechaPago(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (StringUtil.isNullOrEmpty((String)this.getTipoTarjetaCredito())) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de tarjeta de cr\u00e9dito");
        }
        if (!this.validarFechaEmision(resultado).esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    public DatosRecap crearCopiaEdicion() {
        DatosRecap copia = new DatosRecap();
        copia.setTipoComprobante(this.tipoComprobante);
        copia.setDescripcionTipoComprobante(this.descripcionTipoComprobante);
        copia.setNumeroRecap(this.numeroRecap);
        copia.setFechaPago(this.fechaPago);
        copia.setTipoTarjetaCredito(this.tipoTarjetaCredito);
        copia.setDescripcionTarjetaCredito(this.descripcionTarjetaCredito);
        copia.setFechaEmision(this.fechaEmision);
        copia.setPropietario((ObjetoModelo)((Recap)this.propietario));
        return copia;
    }

    public void actualizarInformacion(DatosRecap copiaEdicion) {
        this.setTipoComprobante(copiaEdicion.getTipoComprobante());
        this.setDescripcionTipoComprobante(copiaEdicion.getDescripcionTipoComprobante());
        this.setNumeroRecap(copiaEdicion.getNumeroRecap());
        this.setFechaPago(copiaEdicion.getFechaPago());
        this.setTipoTarjetaCredito(copiaEdicion.getTipoTarjetaCredito());
        this.setDescripcionTarjetaCredito(copiaEdicion.getDescripcionTarjetaCredito());
        this.setFechaEmision(copiaEdicion.getFechaEmision());
    }

    private ResultadoValidacion validarFechaPago(ResultadoValidacion resultado) {
        if (!Util.isFechasIgualesMesAnio(this.getFechaPago(), ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado())) {
            return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del per\u00edodo informado", "pago", "igual"));
        }
        return resultado;
    }

    private ResultadoValidacion validarFechaEmision(ResultadoValidacion resultado) {
        if (!Util.isFechaMenorIgualPeriodoMesAnio(this.getFechaEmision(), ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado())) {
            return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del per\u00edodo informado", "emisi\u00f3n", "menor o igual"));
        }
        return resultado;
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("tarjetaCredito");
        Element eValor = (Element)valorList.item(0);
        this.tipoTarjetaCredito = eValor.getTextContent().trim();
        this.descripcionTarjetaCredito = UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TARJCRED", (String)this.getTipoTarjetaCredito());
        valorList = elemento.getElementsByTagName(C_TIPO_COMPROBANTE);
        eValor = (Element)valorList.item(0);
        this.tipoComprobante = eValor.getTextContent().trim();
        this.descripcionTipoComprobante = String.valueOf(this.getTipoComprobante()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionComprobante(this.getTipoComprobante());
        valorList = elemento.getElementsByTagName(C_NUMERO_RECAP);
        eValor = (Element)valorList.item(0);
        this.numeroRecap = eValor.getTextContent();
        valorList = elemento.getElementsByTagName(C_FECHA_PAGO);
        eValor = (Element)valorList.item(0);
        this.fechaPago = Util.importarFecha(eValor);
        valorList = elemento.getElementsByTagName("fechaEmisionRecap");
        eValor = (Element)valorList.item(0);
        this.fechaEmision = Util.importarFecha(eValor);
        return this;
    }

    public String getTipoComprobante() {
        return this.tipoComprobante;
    }

    public String getDescripcionTipoComprobante() {
        return this.descripcionTipoComprobante;
    }

    public String getNumeroRecap() {
        return this.numeroRecap;
    }

    public Date getFechaPago() {
        return this.fechaPago;
    }

    public String getTipoTarjetaCredito() {
        return this.tipoTarjetaCredito;
    }

    public String getDescripcionTarjetaCredito() {
        return this.descripcionTarjetaCredito;
    }

    public Date getFechaEmision() {
        return this.fechaEmision;
    }

    public void setTipoComprobante(String tipoComprobante) {
        String oldValue = this.tipoComprobante;
        this.tipoComprobante = tipoComprobante;
        this.firePropertyChange(C_TIPO_COMPROBANTE, oldValue, this.tipoComprobante);
    }

    public void setDescripcionTipoComprobante(String descripcionTipoComprobante) {
        this.descripcionTipoComprobante = descripcionTipoComprobante;
    }

    public void setNumeroRecap(String numeroRecap) {
        String oldValue = this.numeroRecap;
        this.numeroRecap = Util.isSoloCeros(numeroRecap) ? "0" : Util.getCadenaFormateada(numeroRecap.toUpperCase(), "15", Character.valueOf('0'));
        this.firePropertyChange(C_NUMERO_RECAP, oldValue, this.numeroRecap);
    }

    public void setFechaPago(Date fechaPago) {
        Date oldValue = this.fechaPago;
        this.fechaPago = fechaPago;
        this.firePropertyChange(C_FECHA_PAGO, oldValue, this.fechaPago);
    }

    public void setTipoTarjetaCredito(String tipoTarjetaCredito) {
        String oldValue = this.tipoTarjetaCredito;
        this.tipoTarjetaCredito = tipoTarjetaCredito;
        this.firePropertyChange(C_TIPO_TARJETA_CREDITO, oldValue, this.tipoTarjetaCredito);
    }

    public void setDescripcionTarjetaCredito(String descripcionTarjetaCredito) {
        this.descripcionTarjetaCredito = descripcionTarjetaCredito;
    }

    public void setFechaEmision(Date fechaEmision) {
        Date oldValue = this.fechaEmision;
        this.fechaEmision = fechaEmision;
        this.firePropertyChange(C_FECHA_EMISION, oldValue, this.fechaEmision);
    }
}

